import { useEffect, useState } from "react"
import { aws } from "@/services/aws"

import { AppState } from "@/types/app"
import { minDelay, sleep } from "@/lib/timing"

/**
 * Hook to setup initial global values used through application
 * @returns current state of the application's initial laod
 */
export function useAppLoading() {
  const [state, setState] = useState<AppState>("loading")

  useEffect(() => {
    if (!setState) {
      return
    }

    async function initGlobalValues() {
      await minDelay(aws.setup(), 100)
      setState("transitioning")
      await sleep(100)
      setState("idle")
    }

    initGlobalValues()

    return () => {
      aws.teardown()
    }
  }, [setState])

  return {
    state,
  }
}
